/* Font Outliner *//*

// 	By Radnen | 2009

//	Disclaimer:

	This is used to outline a font by creating a border around each character in a
font and then saving the font in the end directly over the imported filename.
This is meant as a one-time font outliner. It is only a tool.

*/

function OutlineFont(filename)
{
	var Font = LoadFont(filename);
	var Black = CreateColor( 70,  70,  70);
	var White = CreateColor(255, 255, 255);
	var Clear = CreateColor(0, 0, 0, 0);
	
	var i = 256;
	while(i--) {
		// Grab Font Image:
		var BaseSurf = Font.getCharacterImage(i).createSurface();
		var Surf = BaseSurf.clone();

		Surf.setBlendMode(REPLACE);
		Surf = Surf.resize(Surf.width+1, Surf.height+1);
		Surf.rectangle(0, 0, Surf.width, Surf.height, Clear);
		Surf.blitSurface(BaseSurf, 1, 0);
		Surf.setBlendMode(BLEND);

		BaseSurf = Surf.clone();
		var OutlineSurf = BaseSurf.clone();
		
		// Outline Image:
		BaseSurf.blitMaskSurface(OutlineSurf, 0, -1, Black);
		BaseSurf.blitMaskSurface(OutlineSurf, 0, 1, Black);
		BaseSurf.blitMaskSurface(OutlineSurf, -1, 0, Black);
		BaseSurf.blitMaskSurface(OutlineSurf, 1, 0, Black);
		BaseSurf.blitMaskSurface(OutlineSurf, 1, 1, Black);
		
		// Restore Character:

		BaseSurf.blitMaskSurface(OutlineSurf, 0, 0, White);

		// Set new Image:
		Font.setCharacterImage(i, BaseSurf.createImage());
	}
	
	// Save over Font File:
	Font.save("A"+filename);
}

function game() { OutlineFont("font3.rfn"); }